package main

import "fmt"

/*
	Schreibe ein Programm, das eine angegebene Zeichenkette in Großbuchstaben umwandelt und ausgibt.

Franz jagt im komplett verwahrlosten Taxi quer durch Bayern.

FRANZ JAGT IM KOMPLETT VERWAHRLOSTEN TAXI QUER DURCH BAYERN.
*/
func main() {
	var str = "Franz jagt im komplett verwahrlosten Taxi quer durch Bayern. \U0001F4A9"
	var runes = []rune(str)
	// []byte(str) <- String in Byte-Slice umwandeln
	// []rune(str) <- String in Unicode-Rune-Slice umwandeln

	for i := 0; i < len(runes); i++ {
		if runes[i] >= 'a' && runes[i] <= 'z' {
			runes[i] -= 32
		}
	}

	fmt.Println(str)
	fmt.Println(string(runes))
}
