package main

import (
	"fmt"
	"math"
	"strings"
)

type Point struct {
	X, Y int
}

func GetPoint(name string) Point {
	var point Point
	fmt.Printf("Point %s(x,y)>", name)
	fmt.Scanf("%d,%d\n", &point.X, &point.Y)
	return point
}

func main() {
	var (
		a    = GetPoint("A")
		b    = GetPoint("B")
		maxX = int(math.Max(float64(a.X), float64(b.X)))
		maxY = int(math.Max(float64(a.Y), float64(b.Y)))
	)

	for y := maxY + 1; y > 0; y-- {
		fmt.Printf("%3d |", y)
		for x := 1; x <= maxX+1; x++ {
			if a.Y == y && a.X == x {
				fmt.Print(" A")
			} else if b.Y == y && b.X == x {
				fmt.Print(" B")
			} else {
				fmt.Print("  ")
			}
		}
		fmt.Println()
	}
	fmt.Print("    +", strings.Repeat("-", (maxX+1)*2))
	fmt.Print("\n     ")
	for i := 1; i <= maxX+1; i++ {
		fmt.Printf("%2d", i)
	}
}
