package main

import (
	"bufio"
	"fmt"
	"os"
	"strings"
)

func open(filename string) ([]Person, error) {
	var (
		scanner  *bufio.Scanner
		personen []Person
	)
	if f, err := os.Open(filename); err != nil {
		return nil, err
	} else {
		defer f.Close()
		scanner = bufio.NewScanner(f)
	}
	for scanner.Scan() {
		var line = scanner.Text()
		var cols = strings.Split(line, ",")
		personen = append(personen, Person{cols[0], cols[1], cols[2]})
	}
	return personen, nil
}

func save(filename string, personen []Person) error {
	var (
		f   *os.File
		err error
	)
	if f, err = os.Create(filename); err != nil {
		return err
	}
	defer f.Close()
	for _, p := range personen {
		fmt.Fprintf(f, "%s,%s,%s\n", p.Vorname, p.Nachname, p.Email)
	}
	return nil
}
