package main

import (
	"flag"
	"fmt"
	"log"
	"os"
)

var (
	alphabet  = make([]rune, 52)
	substitut = make([]rune, 52)
)

func encodeChar(char rune) rune {
	for i := 0; i < len(alphabet); i++ {
		if alphabet[i] == char {
			return substitut[i]
		}
	}
	return char
}

func decodeChar(char rune) rune {
	for i := 0; i < len(substitut); i++ {
		if substitut[i] == char {
			return alphabet[i]
		}
	}
	return char
}

func main() {
	var (
		verschiebefaktor int
		decode           bool
	)
	flag.IntVar(&verschiebefaktor, "rot", 13, "Buchstabenrotation (1-25)")
	flag.BoolVar(&decode, "decode", false, "Text entschlüsseln")
	flag.Parse()

	if flag.NArg() != 2 {
		flag.Usage()
		os.Exit(1)
	}

	for i := 0; i < 26; i++ {
		alphabet[i] = 'A' + rune(i)
		alphabet[i+26] = 'a' + rune(i)
	}

	for i := 0; i < 26; i++ {
		if i+verschiebefaktor < 26 {
			substitut[i] = alphabet[i+verschiebefaktor]
			substitut[i+26] = alphabet[i+26+verschiebefaktor]
		} else {
			substitut[i] = alphabet[i+verschiebefaktor-26]
			substitut[i+26] = alphabet[i+26+verschiebefaktor-26]
		}
	}

	fmt.Println(string(alphabet))
	fmt.Println(string(substitut))

	var textRunes []rune
	if b, err := os.ReadFile(flag.Arg(0)); err == nil {
		textRunes = []rune(string(b))
		for index, char := range textRunes {
			if decode {
				textRunes[index] = decodeChar(char)
			} else {
				textRunes[index] = encodeChar(char)
			}
		}
	} else {
		log.Fatal(err)
	}

	if err := os.WriteFile(flag.Arg(1), []byte(string(textRunes)), 0644); err != nil {
		log.Fatal(err)
	}
}
