package main

import (
	"fmt"
	"time"
)

type Mitarbeiter interface {
	// Alter gibt das Alter in Jahren zurück
	Alter() int
	// Stringer.string() gibt bei Menschen Vorname, Nachname und Geburtsdatum aus,
	// bei Robotern nur die Seriennummer
	fmt.Stringer
}
type Mensch struct {
	Vorname, Nachname string
	Geburtsdatum      time.Time
}

func (m Mensch) Alter() int {
	return int(time.Now().Sub(m.Geburtsdatum).Hours() / 24 / 365)
}
func (m Mensch) String() string {
	return fmt.Sprintf("%s %s %s", m.Vorname, m.Nachname, m.Geburtsdatum.Format(time.DateOnly))
}

type Roboter struct {
	Seriennummer int
	Baujahr      time.Time
}

func (r Roboter) Alter() int {
	return int(time.Now().Sub(r.Baujahr).Hours() / 24 / 365)
}
func (r Roboter) String() string {
	return fmt.Sprintf("%d", r.Seriennummer)
}

func main() {
	var alleMitarbeiter []Mitarbeiter = []Mitarbeiter{
		Mensch{"John", "Doe", time.Date(1977, time.January, 5, 0, 0, 0, 0, time.UTC)},
		Roboter{Seriennummer: 4453, Baujahr: time.Date(2020, time.January, 9, 0, 0, 0, 0, time.UTC)},
	}

	var mitarbeiter = Mensch{}
	mitarbeiter.Vorname = "John"
	mitarbeiter.Nachname = "Doe"
	mitarbeiter.Geburtsdatum = time.Now()

	alleMitarbeiter = append(alleMitarbeiter, mitarbeiter)

	for _, m := range alleMitarbeiter {
		fmt.Println(m, m.Alter())
	}
}
