package main

import "fmt"

type IPAdresse [4]byte

func (ip IPAdresse) String() string {
	return fmt.Sprintf("%d.%d.%d.%d", ip[0], ip[1], ip[2], ip[3])
}

func (ip *IPAdresse) Set(index int, b byte) {
	ip[index] = b
}

func main() {
	var ip IPAdresse = IPAdresse{127, 0, 0, 1}
	ip.Set(2, 255)

	fmt.Println(ip)

	var customer = &Customer{
		ID: 223323,
		Person: Person{
			Vorname:  "John",
			Nachname: "Schmith",
		},
	}
	//customer.ID = 123
	//customer.Adresse.PLZ = "90461"
	fmt.Println(customer.ID)
	fmt.Println(customer.Vorname)
	fmt.Println(customer.Adresse.PLZ)

	var err error = nil
	fmt.Println(err)

	var ding fmt.Stringer
	ding = ip

	var ip2, ok = ding.(Customer)
	fmt.Println(ip2, ok)

	var a any

	a = 5
	a = "Hallo"
	a = 5.3

	switch a.(type) {
	case int:
		fmt.Println("int")
	case string:
		fmt.Println("string")
	case float64:
		fmt.Println("float64")
	default:
		fmt.Println("unknown")
	}
}
