package bubblesort

import (
	"reflect"
	"testing"
)

func TestSort_unsorted_slice_with_duplicates(t *testing.T) {
	var (
		given = []int{5, 7, 21, 7, 11, 6, 16, 4, 8, 6}
		want  = []int{4, 5, 6, 6, 7, 7, 8, 11, 16, 21}
	)

	if got := Sort(given); !reflect.DeepEqual(got, want) {
		t.Errorf("Sort(%v) should return %v, but returned %v", given, want, got)
	}
}

func TestSort_sorted_slice(t *testing.T) {
	var (
		given = []int{11, 22, 33, 44, 55, 66, 77, 88, 99}
		want  = given
	)

	if got := Sort(given); !reflect.DeepEqual(got, want) {
		t.Errorf("Sort(%v) should return %v, but returned %v", given, want, got)
	}
}

func TestSort_reverse_sorted_slice(t *testing.T) {
	var (
		given = []int{99, 88, 77, 66, 55, 44, 33, 22, 11}
		want  = []int{11, 22, 33, 44, 55, 66, 77, 88, 99}
	)

	if got := Sort(given); !reflect.DeepEqual(got, want) {
		t.Errorf("Sort(%v) should return %v, but returned %v", given, want, got)
	}
}
