package genbubsort

type Number interface {
	int | int8 | int16 | int32 | float64 | uint | string
}

func Sort[T Number](a []T) []T {
	var swapped = false
	for n := len(a); n > 1; n-- {
		for i := 0; i < n-1; i++ {
			if a[i] > a[i+1] {
				a[i], a[i+1] = a[i+1], a[i]
				swapped = true
			}
		}
		if swapped == false {
			break
		}
	}
	return a
}
