package main

import (
	"fmt"
	"github.com/lehrcode/sortieralgorithmen/bubblesort"
	"github.com/lehrcode/sortieralgorithmen/insertionsort"
	"github.com/lehrcode/sortieralgorithmen/mergesort"
	"github.com/lehrcode/sortieralgorithmen/shakersort"
	"math/rand"
	"time"
)

func RandomInts(n int) []int {
	result := make([]int, n)
	for i := 0; i < n; i++ {
		result[i] = rand.Intn(10_000)
	}
	return result
}

func main() {
	var unsorted = RandomInts(100_000)
	//fmt.Println("unsorted:", unsorted)

	var sorted1 = make([]int, len(unsorted))
	copy(sorted1, unsorted)
	var start1 = time.Now().UnixMilli()
	sorted1 = bubblesort.Sort(sorted1)
	fmt.Printf("Bubblesort %dms\n", time.Now().UnixMilli()-start1)
	//fmt.Println("sorted1:", sorted1)

	var sorted2 = make([]int, len(unsorted))
	copy(sorted2, unsorted)
	var start2 = time.Now().UnixMilli()
	sorted2 = mergesort.Sort(sorted2)
	fmt.Printf("Mergesort %dms\n", time.Now().UnixMilli()-start2)
	//fmt.Println("sorted2:", sorted2)

	var sorted3 = make([]int, len(unsorted))
	copy(sorted3, unsorted)
	var start3 = time.Now().UnixMilli()
	sorted3 = insertionsort.Sort(sorted3)
	fmt.Printf("Insertionsort %dms\n", time.Now().UnixMilli()-start3)
	//fmt.Println("sorted3:", sorted3)

	var sorted4 = make([]int, len(unsorted))
	copy(sorted4, unsorted)
	var start4 = time.Now().UnixMilli()
	sorted4 = shakersort.Sort(sorted4)
	fmt.Printf("Shakersort %dms\n", time.Now().UnixMilli()-start4)
	//fmt.Println("sorted4:", sorted4)

	var sorted5 = make([]int, len(unsorted))
	copy(sorted5, unsorted)
	var start5 = time.Now().UnixMilli()
	sorted5 = shakersort.Sort(sorted5)
	fmt.Printf("Shellsort %dms\n", time.Now().UnixMilli()-start5)
	//fmt.Println("sorted5:", sorted5)
}
