package mergesort

import "fmt"

/*
stabil
rekursiv
out-of-place

best case:		Omega (n log n)
average case:	Θ (n log n )
worst case:		O (n\log n)
*/

func main() {
	a := []int{5, 64, 87, 32, 47, 363, 82133, 3, 8, 764, 36, 5, 6, 89, 6, 4655, 23, 4, 3, 6364, 7}
	a = Sort(a)
	fmt.Println(a)
}

func Sort(a []int) []int {
	if len(a) < 2 {
		return a
	}

	left := Sort(a[:len(a)/2])
	right := Sort(a[len(a)/2:])
	return merge(left, right)
}

func merge(a []int, b []int) []int {
	final := []int{}
	i := 0
	j := 0

	for i < len(a) && j < len(b) {
		if a[i] < b[j] {
			final = append(final, a[i])
			i++
		} else {
			final = append(final, b[j])
			j++
		}
	}

	for ; i < len(a); i++ {
		final = append(final, a[i])
	}

	for ; j < len(b); j++ {
		final = append(final, b[j])
	}

	return final
}
