package cipher

type Caesar struct {
	//alphabet  []rune
	//substitut []rune
	encodeChars map[rune]rune
	decodeChars map[rune]rune
}

func New(verschiebefaktor int) Caesar {
	var newCaesar Caesar

	var (
		alphabet  = make([]rune, 52)
		substitut = make([]rune, 52)
	)

	for i := 0; i < 26; i++ {
		alphabet[i] = 'A' + rune(i)
		alphabet[i+26] = 'a' + rune(i)
	}

	for i := 0; i < 26; i++ {
		if i+verschiebefaktor < 26 {
			substitut[i] = alphabet[i+verschiebefaktor]
			substitut[i+26] = alphabet[i+26+verschiebefaktor]
		} else {
			substitut[i] = alphabet[i+verschiebefaktor-26]
			substitut[i+26] = alphabet[i+26+verschiebefaktor-26]
		}
	}

	newCaesar.encodeChars = make(map[rune]rune)
	newCaesar.decodeChars = make(map[rune]rune)

	for i, c := range alphabet {
		newCaesar.encodeChars[c] = substitut[i]
	}
	for i, c := range substitut {
		newCaesar.decodeChars[c] = alphabet[i]
	}

	return newCaesar
}
