package main

import "fmt"

type Node struct {
	data any
	next *Node
}

type LinkedList struct {
	head *Node
}

func (l *LinkedList) Print() {
	for currentNode := l.head; currentNode != nil; currentNode = currentNode.next {
		fmt.Print("[", currentNode.data, "]")
	}
	fmt.Println()
}

func (l *LinkedList) Add(data any) {
	var newNode = &Node{data: data}
	if l.head == nil {
		l.head = newNode
		return
	}
	var lastNode *Node
	for currentNode := l.head; currentNode != nil; currentNode = currentNode.next {
		lastNode = currentNode
	}
	lastNode.next = newNode
}

func (l *LinkedList) Push(data any) {
	var newNode = &Node{data: data, next: l.head}
	l.head = newNode
}

func (l *LinkedList) Pop() any {
	var value any
	if l.head == nil {
		return nil
	}
	value = l.head.data
	l.head = l.head.next
	return value
}

func (l *LinkedList) PopLast() any {
	var value any
	if l.head == nil {
		return nil
	}
	var lastNode, prevNode *Node
	for currentNode := l.head; currentNode != nil; currentNode = currentNode.next {
		prevNode = lastNode
		lastNode = currentNode
	}
	if prevNode == nil {
		value = l.head.data
		l.head = nil
	} else {
		value = lastNode.data
		prevNode.next = nil
	}
	return value
}

func main() {
	var list = new(LinkedList)
	list.Add(1)
	list.Add(2)
	list.Add(3)
	list.Print()
	fmt.Println(list.PopLast())
	fmt.Println(list.PopLast())
	fmt.Println(list.PopLast())
	list.Print()
}
